#! /usr/bin/env python
#coding=utf-8
import os
import numpy as np
from osgeo import gdal
from osgeo import gdal_array
from osgeo import osr
import matplotlib.pylab as plt
from netCDF4 import Dataset
import datetime, calendar
import time,datetime
today = datetime.date.today()
daynow = today.strftime("%Y%m%d")
daynow1=today.strftime("%Y-%m-%d")
path='/home/data/yutu03/yutu/sharedata/cd/'+daynow
if not os.path.exists(path):
    os.makedirs(path)
else:
    print('目录已存在')
file="/home/gcsoft/cd/wrfout/"+daynow+"/wrfout_d02_"+daynow1+"_00:00:00"
print file
fh = Dataset(file, mode='r')
lat=fh.variables['XLAT'][0,:,:]
lon=fh.variables['XLONG'][0,:,:]
num=[2,5]
name=["10","13"]
for i in range(2):
    hgt=fh.variables['PBLH'][num[i],:,:]
    xmin,ymin,xmax,ymax = [lon.min(),lat.min(),lon.max(),lat.max()]
    nrows,ncols = np.shape(hgt)
    xres = (xmax-xmin)/float(ncols)
    yres = (ymax-ymin)/float(nrows)
    geotransform=(xmin,xres,0,ymax,0, -yres)
    output_raster = gdal.GetDriverByName('GTiff').Create(path+'/'+name[i]+'pblh.tif',ncols, nrows, 1 ,gdal.GDT_Float32)  # Open the file
    output_raster.SetGeoTransform(geotransform)  # Specify its coordinates
    srs = osr.SpatialReference()                 # Establish its coordinate encoding
    srs.ImportFromEPSG(4326)                     # This one specifies WGS84 lat long.
                                                 # Anyone know how to specify the 
                                                 # IAU2000:49900 Mars encoding?
    output_raster.SetProjection( srs.ExportToWkt() )   # Exports the coordinate system 
                                                       # to the file
    output_raster.GetRasterBand(1).WriteArray(hgt[::-1])   # Writes my array to the raster
    file1="/home/gcsoft/cd/foo.nc"
    fh1 = Dataset(file1, mode='r')
    rh=fh1.variables['rh'][num[i],:,:]
    output_raster = gdal.GetDriverByName('GTiff').Create(path+'/'+name[i]+'rh.tif',ncols, nrows, 1 ,gdal.GDT_Float32)  # Open the file
    output_raster.SetGeoTransform(geotransform)  # Specify its coordinates
    srs = osr.SpatialReference()                 # Establish its coordinate encoding
    srs.ImportFromEPSG(4326)                     # This one specifies WGS84 lat long.
                                                 # Anyone know how to specify the 
                                                 # IAU2000:49900 Mars encoding?
    output_raster.SetProjection( srs.ExportToWkt() )   # Exports the coordinate system 
                                                       # to the file
    output_raster.GetRasterBand(1).WriteArray(rh[::-1])   # Writes my array to the raster    

